﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Services;
using Newtonsoft.Json;

namespace AZVIC.Ei8htPOS.WebUI.WebService
{
    /// <summary>
    /// Summary description for ARService
    /// </summary>
    [WebService(Namespace = "http://tempuri.org/")]
    [WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
    [System.ComponentModel.ToolboxItem(false)]
    // To allow this Web Service to be called from script, using ASP.NET AJAX, uncomment the following line. 
    [System.Web.Script.Services.ScriptService]
    public class ARService : System.Web.Services.WebService
    {
        /// <summary>
        /// Get the products list from Azvic ERP System.
        /// </summary>
        /// <param name="AccessKey">Specify the shared Access Key</param>
        /// <param name="ProductID">Specify Product ID if known and want to get product details or send 00000000-0000-0000-0000-000000000000</param>
        /// <param name="Keyword">Specify keyword if any</param>
        /// <returns>List of Products / Product based on the productID and keyword specified</returns>
        [WebMethod]
        public string GetProducts(Guid AccessKey, Guid ProductID, string Keyword = "")
        {
            List<Products> productList;
            List<Products> pcList = new List<Products>(); ;
            Guid SharedKey = Guid.Parse(System.Web.Configuration.WebConfigurationManager.AppSettings["ARSharedKey"].ToString());
            if (AccessKey == SharedKey)
            {
                productList = ProductsBL.GetList(ProductID, Keyword);
                //productList.ForEach(a => a.Mode = a.Mode!=0 ? a.Mode : Utilities.GlobalConfigurations.Mode.Search);
                pcList = productList.Where(m => m.IsMiscellaneous == false && m.IsARProduct == true)
                                    .OrderBy(x => x.SequenceNo).ToList<Products>();
            }

            //return pcList;

            string jsonOutput = JsonConvert.SerializeObject(pcList);

            return jsonOutput;
        }
    }
}
